/**
 * Class ........: Invoice
 * Description ..: This is the Invoice object which represents a supplier's invoice.  The details of
 *                 the invoice are retrieved from the remote database on the server, and the Invoice
 *                 object is created accordingly.
 *
 *                 The object is returned to the calling method on the AS/400, where it's values are
 *                 extracted and passed back up the call stack to the original program that requested
 *                 the invoice details.
 *
 * @author Liam McMahon
 * @version 1.0
 */


import java.io.*;

public class Invoice implements Serializable {

      /**
       * Define the invoice attributes.
       */

      public int        invoice;
      public double     invoiceVal;
      public String     invoiceCurr;
      public String     invoiceSts;


      /**
       * Construct the Invoice class, using the invoice attributes that are passed in.
       *
       */

      public Invoice(int invoice, double invoiceVal, String invoiceCurr, String invoiceSts) {

            this.invoice     = invoice;
            this.invoiceVal  = invoiceVal;
            this.invoiceCurr = invoiceCurr;
            this.invoiceSts  = invoiceSts;
      }
}