import java.math.*;
import com.ibm.as400.access.*;
import com.ibm.as400.data.*;
public class PcmlExample
{
  public PcmlExample()
  {
  }
  public static void main(String args[])
  {
    /* Minimal error trapping uses a single try/catch */
    try
    {
      /* Set up AS400 connection and link to PCML document */
      AS400 myAS400Connection = new AS400();
      ProgramCallDocument testPCML = new ProgramCallDocument
                                         (
                                           myAS400Connection, "PCMLSample"
                                         );

      /* Set input parameters */
      String product = new String("redWidget");
      testPCML.setValue("PCMLTEST.InputStructure.productCode", product);

      BigDecimal customer = new BigDecimal(1234567);
      testPCML.setValue("PCMLTEST.InputStructure.customerNumber", customer);

      BigDecimal quantity = new BigDecimal(42);
      testPCML.setValue("PCMLTEST.InputStructure.quantityOrdered", quantity);

      /* Call the program */
      if (testPCML.callProgram("PCMLTEST"))
        {
          /* If the program ran successfully retrieve the output parameter */
          BigDecimal price =((BigDecimal)testPCML.getValue("PCMLTEST.price"));
          System.out.println("The price returned is " + price);
        }
    }

    catch (PcmlException exc)
    {
      System.out.println("an error occured ");
      System.out.println(exc.getMessage());
    }
    System.exit(0);
  }

}