import java.math.*;
import com.ibm.as400.access.*;
public class ProgramCallDSExample
{
  public ProgramCallDSExample()
  {
  }

  public static void main(String args[])
  {
    /* Minimal error trapping uses a single try/catch */
    try
    {
      /* Build data individual input parameter components */
      String product = new String("redWidget");
      byte parmDataStructureProduct[] = new byte[10];
      AS400Text productTextConverter = new AS400Text(10);
      parmDataStructureProduct = productTextConverter.toBytes(product);

      BigDecimal customer = new BigDecimal(1234567);
      byte parmDataStructureCustomer[] = new byte[4];
      AS400PackedDecimal customerPackedConverter = new AS400PackedDecimal(7, 0);
      parmDataStructureCustomer = customerPackedConverter.toBytes(customer);

      BigDecimal quantity = new BigDecimal(42);
      byte parmDataStructureQuantity[]= new byte[5];
      AS400ZonedDecimal quantityZonedConverter = new AS400ZonedDecimal(5, 0);
      parmDataStructureQuantity = quantityZonedConverter.toBytes(quantity);

      /* Assemble the input parameter data structure */
      byte completeDS[] = new byte[19];
      System.arraycopy(parmDataStructureProduct, 0, completeDS, 0, 10);
      System.arraycopy(parmDataStructureCustomer, 0, completeDS, 10, 4);
      System.arraycopy(parmDataStructureQuantity, 0, completeDS, 14, 5);

      /* Build the program parameter array */
      ProgramParameter iSeriesParameters [] = new ProgramParameter[2];
      iSeriesParameters[0] = new ProgramParameter(completeDS);
      iSeriesParameters[1] = new ProgramParameter(7);
      /* Call the program */
      AS400 myAS400Connection = new AS400();
      ProgramCall testProgramCall = new ProgramCall(myAS400Connection);
testProgramCall.setProgram("/QSYS.LIB/HOFFMAN.LIB/PCMLDS.PGM", iSeriesParameters);
      if (testProgramCall.run())
        {
          /* If the program ran successfully retrieve the output parameter */
          AS400PackedDecimal pricePackedConverter = new AS400PackedDecimal(7, 2);
          BigDecimal price = ((BigDecimal)pricePackedConverter.toObject
                               (
                                 iSeriesParameters[1].getOutputData()
                               )
                             );
          System.out.println("The new price is " + price);
        }
    }

    catch (Exception exc)
    {
      System.out.println("an error occured ");
      System.out.println(exc.getMessage());
    }
    System.exit(0);
  }

}